/*******************************************************************************
********************************************************************************
**  SAE J1699-5 Vehicle OBD II Compliance Test Cases Source Code
**
**   Copyright (C) 2022
**
**  ****************************************************************************
**
**  This source code is intended to run the tests described in
**  the SAE J1699-5 document in an automated manner, when compiled
**  and used with an SAE J2534-compatible pass-thru device.
**
**  File j1699.c contains information on building and running this test.
**
********************************************************************************
*******************************************************************************/

#include <stdio.h>    // C Library input and output declarations
#include <stdlib.h>   // C Library general function declarations
#include <time.h>     // C Library time and date declarations
#include <windows.h>  // Windows API declarations
#include "j2534.h"    // j1699 project j2534 declarations
#include "j1699.h"    // j1699 project general declarations


/*******************************************************************************
**
**  Function:  DisconnectOBDProtocol
**
**  Purpose:   Disconnect a protocol
**
*******************************************************************************/
STATUS DisconnectOBDProtocol ( void )
{
	STATUS eRetVal;
	STATUS eRetCode = PASS;


	// Turn off all filters and periodic messages before disconnecting
	if ( (eRetVal = PassThruIoctl ( gstProtocolList[gProtocolIdx].ChannelID,
	                                CLEAR_MSG_FILTERS,
	                                NULL,
	                                NULL )) != STATUS_NOERROR )
	{
		// If determining protocol,
		// don't print to the screen j2534 device error caused by incorrect number of ecus entered by user
		if ( eRetVal == ERR_DEVICE_NOT_CONNECTED &&
		     gbProtocolDetermined == FALSE )
		{
			Log ( J2534_FAILURE, SCREENOUTPUTOFF, LOGOUTPUTON, NO_PROMPT,
			      "%s returned %ld",
			      "PassThruDisconnect",
			      eRetVal );
		}
		else
		{
			Log ( J2534_FAILURE, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "%s returned %ld",
			      "PassThruIoctl(CLEAR_MSG_FILTERS)",
			      eRetVal );
		}
		eRetCode = FAIL;
	}

	StopPeriodicMsg ( FALSE );

	// Disconnect protocol
	if ( (eRetVal = PassThruDisconnect ( gstProtocolList[gProtocolIdx].ChannelID )) != STATUS_NOERROR )
	{
		// If determining protocol,
		// don't print to the screen j2534 device error caused by incorrect number of ecus entered by user
		if ( (eRetVal == ERR_DEVICE_NOT_CONNECTED ||
		      gstProtocolList[gProtocolIdx].ChannelID == 0) &&
		     gbProtocolDetermined == FALSE )
		{
			Log ( J2534_FAILURE, SCREENOUTPUTOFF, LOGOUTPUTON, NO_PROMPT,
			      "%s returned %ld",
			      "PassThruDisconnect",
			      eRetVal );
		}
		else
		{
			Log ( J2534_FAILURE, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "%s returned %ld",
			      "PassThruDisconnect",
			      eRetVal );
		}
		eRetCode = FAIL;
	}

	return eRetCode;
}
