/*******************************************************************************
********************************************************************************
**  SAE J1699-5 Vehicle OBD II Compliance Test Cases Source Code
**
**   Copyright (C) 2022
**
**  ****************************************************************************
**
**  This source code is intended to run the tests described in
**  the SAE J1699-5 document in an automated manner, when compiled
**  and used with an SAE J2534-compatible pass-thru device.
**
**  File j1699.c contains information on building and running this test.
**
********************************************************************************
*******************************************************************************/

/*******************************************************************************
**
**  Screen Data Structures
**
*******************************************************************************/
typedef struct _StaticTextElement
{
   char * szLabel;
   short  X;
   short  Y;
} StaticTextElement;

typedef struct _DynamicValueElement
{
   short  X;
   short  Y;
   int    Width;
} DynamicValueElement;

/*******************************************************************************
**
**  Dynamic Screen Handling Functions
**
*******************************************************************************/
void init_screen        ( StaticTextElement   elements[], int num_elements );
void place_screen_text  ( StaticTextElement   elements[], int num_elements );
void update_screen_dec  ( DynamicValueElement elements[], int num_elements, int index, int value );
void update_screen_hex  ( DynamicValueElement elements[], int num_elements, int index, int value );
void update_screen_text ( DynamicValueElement elements[], int num_elements, int index, const char *value );


/*******************************************************************************
**
**  Low-Level Screen Functions
**
*******************************************************************************/
void gotoxy ( short x, short y );
void setrgb ( int color );
void clrscr ( );
void get_cursor_pos ( short * x, short * y );