/*******************************************************************************
********************************************************************************
**  SAE J1699-5 Vehicle OBD II Compliance Test Cases Source Code
**
**   Copyright (C) 2022
**
**  ****************************************************************************
**
**  This source code is intended to run the tests described in
**  the SAE J1699-5 document in an automated manner, when compiled
**  and used with an SAE J2534-compatible pass-thru device.
**
**  File j1699.c contains information on building and running this test.
**
********************************************************************************
*******************************************************************************/

#include <stdio.h>    // C Library input and output declarations
#include <stdlib.h>   // C Library general function declarations
#include <time.h>     // C Library time and date declarations
#include <windows.h>  // Windows API declarations
#include "j2534.h"    // j1699 project j2534 declarations
#include "j1699.h"    // j1699 project general declarations


/*******************************************************************************
**
**  Function:  LogMsg
**
**  Purpose:   Log Network messages to logfile
**
*******************************************************************************/
void LogMsg ( PASSTHRU_MSG  *pMsg,
              unsigned long  MsgFlags )
{
	char          LogBuffer[MAX_LOG_STRING_SIZE];
	unsigned long ByteIdx;
	unsigned long BufferIdx;


	BufferIdx = 0;

	if ( MsgFlags & LOG_REQ_MSG )
	{
		// For local messages, set ExtraDataIndex to message size.
		pMsg->ExtraDataIndex = pMsg->DataSize;
		BufferIdx += sprintf_s ( &LogBuffer[BufferIdx], MAX_LOG_STRING_SIZE - BufferIdx,
		                         "REQ MSG:  " );
	}
	else if ( pMsg->RxStatus & TX_MSG_TYPE )
	{
		BufferIdx += sprintf_s ( &LogBuffer[BufferIdx], MAX_LOG_STRING_SIZE - BufferIdx,
		                         "TX MSG: %10luusec ",
		                         pMsg->TimestampMsecs );
	}
	else
	{
		BufferIdx += sprintf_s ( &LogBuffer[BufferIdx], MAX_LOG_STRING_SIZE - BufferIdx,
		                         "RX MSG: %10luusec ",
		                         pMsg->TimestampMsecs );
	}


	switch ( pMsg->eProtocolID )
	{
		case ISO15765:
		{
			BufferIdx += sprintf_s ( &LogBuffer[BufferIdx], MAX_LOG_STRING_SIZE - BufferIdx,
			                         "ISO15765 " );
		}
		break;
		case CAN:
		{
			BufferIdx += sprintf_s ( &LogBuffer[BufferIdx], MAX_LOG_STRING_SIZE - BufferIdx,
			                         "CAN " );
		}
		break;
		default:
		{
			// Unsupported protocol
		}
		break;
	}

	if ( pMsg->RxStatus & ISO15765_FIRST_FRAME )
	{
		BufferIdx += sprintf_s ( &LogBuffer[BufferIdx], MAX_LOG_STRING_SIZE - BufferIdx,
		                         "FirstFrame Indication " );
	}
	else if ( pMsg->RxStatus & TX_DONE )
	{
		BufferIdx += sprintf_s ( &LogBuffer[BufferIdx], MAX_LOG_STRING_SIZE - BufferIdx,
		                         "Tx Done Indication " );
	}

	if ( pMsg->RxStatus & RX_BREAK )
	{
		BufferIdx += sprintf_s ( &LogBuffer[BufferIdx], MAX_LOG_STRING_SIZE - BufferIdx,
		                         "BREAK Indication " );
	}
	for ( ByteIdx = 0;
	      ByteIdx < pMsg->ExtraDataIndex &&
	      ByteIdx < pMsg->DataSize &&
	      ByteIdx < MAX_MESSAGE_LOG_SIZE;
	      ByteIdx++ )
	{
		BufferIdx += sprintf_s ( &LogBuffer[BufferIdx], MAX_LOG_STRING_SIZE - BufferIdx,
		                         "%02X ",
		                         pMsg->Data[ByteIdx] );
	}

	BufferIdx += sprintf_s ( &LogBuffer[BufferIdx], MAX_LOG_STRING_SIZE - BufferIdx,
	                         "\n" );

	Log ( NETWORK, SCREENOUTPUTOFF, LOGOUTPUTON, NO_PROMPT,
	      "%s",
	      LogBuffer );
}
