/*******************************************************************************
********************************************************************************
**
**  Copyright(c) 2022, Alliance for Automotive Innovation
**  Used only under license from the Alliance for Automotive Innovation. All Rights Reserved.
**
**  Project:  J1699-5
**  FileName: VerifyECUCommunication.c
**  Author:   EnGenius
**  Date:     2/25/2022
**  Email:    <support@autosinnovate.org>
**
**  Purpose:  SAE J1699-5 Vehicle OBD II Compliance Test Cases Source Code.
**            This source code is intended to run the tests described in
**            the SAE J1699-5 document in an automated manner, when compiled
**            and used with an SAE J2534-compatible pass-thru device.
**
**            File j1699.c contains information on building and running this test.
**
**  Description:
**
**  Modifications:  03/13/2023  Initial Version
**
********************************************************************************
*******************************************************************************/

#include <stdio.h>    // C Library input and output declarations
#include <stdlib.h>   // C Library general function declarations
#include <time.h>     // C Library time and date declarations
#include <windows.h>  // Windows API declarations
#include "j2534.h"    // j1699 project j2534 declarations
#include "j1699.h"    // j1699 project general declarations


// Variables
BOOL gbVerifyLink;   // flag to indicate ResetSIDResponseData (called by RequestSID) should not clear all pid supported pids


/*******************************************************************************
**
**  Function:  VerifyECUCommunication
**
**  Purpose:   Check if link remained active.
**
*******************************************************************************/
STATUS VerifyECUCommunication ( void )
{
	REQ_MSG  stReqMsg;
	BYTE     EcuIdx = 0;
	BYTE     EcuRespCnt = 0;


	gbIgnoreUnsupported = TRUE;
	Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
	      "Verify Link Active\n" );

	gbVerifyLink = TRUE;

	// Check if PID $F400 supported
	stReqMsg.SID      = 0x22;
	stReqMsg.NumIds   = 1;
	stReqMsg.u.DID[0] = 0xF810;
	if ( RequestSID ( &stReqMsg, REQ_MSG_NORMAL ) == PASS )
	{
		for ( EcuIdx = 0;
		      EcuIdx < gNumOfECUs;
		      EcuIdx++ )
		{
			if ( gstResponse[EcuIdx].bLinkActive == TRUE )
			{
				// We've found an OBD supported protocol
				Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
				      "ECU %X  Link Active on OBD %s protocol\n",
				      GetEcuId ( EcuIdx ),
				      gstProtocolList[gProtocolIdx].Name );
				EcuRespCnt++;
			}
			else
			{
				Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
				      "ECU %X  No Response!\n",
				      GetEcuId ( EcuIdx ) );
			}
		}
	}
	gbIgnoreUnsupported = FALSE;

	gbVerifyLink = FALSE;

	// Verify that all controllers responded.
	if ( EcuRespCnt == gUserNumOfECUs )
	{
		Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
		      "Link Active\n" );
		return PASS;
	}
	else
	{
		Log ( FAILURE, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
		      "Incorrect number of responses to PID $F810 request (%d responses, %d expected)!\n",
		      EcuRespCnt,
		      gUserNumOfECUs );

		return FAIL;
	}
}
