#define _WINSOCK_DEPRECATED_NO_WARNINGS 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <Winsock2.h>
#include <ws2tcpip.h>
#include <process.h>
#include "DoIP.h"     // j1699 project DoIP declarations
#include "j2534.h"    // j1699 project j2534 declarations
#include "j1699.h"    // j1699 project general declarations


// External Variables
//extern BYTE gTestDIDCount;


// Local Variables and Constants
BOOL bNetworkStarted;

#define DOIP_TIMEOUT 2000

#define MAX_READ_ATTEMPTS 2   // maximum number of consecutive attempts to read without receiving data
#define MAX_WRITE_ATTEMPTS 3  // maximum number of consecutive attempts to write without response

#define MAX_IPV4_ADDRESS_LENGTH 4
#define MAX_IPV4_ADDRESS_STRING_LENGTH 16
#define MAX_IPV6_ADDRESS_LENGTH 16
#define MAX_IPV6_ADDRESS_STRING_LENGTH 64
#define MAX_IP_ADDRESSES 10
t_stIPAddressInfo IPAddressInfo[MAX_IP_ADDRESSES];
BYTE              IPAddressInfoCount = 0;

// USB          Client address 192.168.171.30
// WIFI PtoP    Client address 192.168.174.50
//char acTesterAddress[MAX_IPV4_ADDRESS_STRING_LENGTH]  = "192.168.171.30";
//char acVehicleAddress[MAX_IPV4_ADDRESS_STRING_LENGTH] = "192.168.171.100";


#define TESTERADDRESS     0x0E00
#define FUNCTIONALADDRESS 0xE000
#define TESTERPORT        13400

static t_stSocketData  stSocketData;

BYTE RcvdIPAddress[16];

BOOL   gbUseTesterIPv4Address;
DWORD  gulTesterIPv4Address;
BYTE   gTesterIPv4Address[4];
BYTE   gTesterIPv4AddressString[16];

BOOL   gbUseTesterIPv6Address;
DWORD  gulTesterIPv6Address;
BYTE   gTesterIPv6Address[4];
BYTE   gTesterIPv6AddressString[16];

BOOL   gbUseVehicleIPv4Address;
DWORD  gulVehicleIPv4Address;
BYTE   gVehicleIPv4Address[4];
BYTE   gVehicleIPv4AddressString[16];

BOOL   gbUseVehicleIPv6Address;
DWORD  gulVehicleIPv6Address;
BYTE   gVehicleIPv6Address[4];
BYTE   gVehicleIPv6AddressString[16];


unsigned short ausSocketErrors[NUM_SOCKET_ERRORS] =
{
	8,
	10004,
	10009,
	10013,
	10014,
	10022,
	10024,
	10035,
	10036,
	10037,
	10038,
	10039,
	10040,
	10041,
	10042,
	10043,
	10044,
	10045,
	10046,
	10047,
	10048,
	10049,
	10050,
	10051,
	10052,
	10053,
	10054,
	10055,
	10056,
	10057,
	10058,
	10059,
	10060,
	10061,
	10062,
	10063,
	10064,
	10065,
	10067,
	10091,
	10092,
	10093,
	10094,
	10101,
	10109,
	11001,
	11002,
	11003,
	11004,
};

#define MAX_ERR_DESC_LEN 60
char aszSocketErrorDescriptions[eMaxSocketErrorCodes + 1][MAX_ERR_DESC_LEN] =
{
	"SOCKET 8 - Not Enough Memory",                             // WSA_NOT_ENOUGH_MEMORY
	"SOCKET 10004 - Interrupted system call",                   // WSAEINTR
	"SOCKET 10009 - Bad file number",
	"SOCKET 10013 - Permission denied",                         // WSAEACCES
	"SOCKET 10014 - Bad address",                               // WSAEFAULT
	"SOCKET 10022 - Invalid argument",                          // WSAEINVAL
	"SOCKET 10024 - Too many open files",                       // WSAEMFILE
	"SOCKET 10035 - Operation would block",                     // WSAEWOULDBLOCK
	"SOCKET 10036 - Operation now in progress",                 // WSAEINPROGRESS
	"SOCKET 10037 - Operation already in progress",             // WSAEALREADY
	"SOCKET 10038 - Socket operation on nonsocket",             // WSAENOTSOCK
	"SOCKET 10039 - Destination address required",              // WSAEDESTADDRREQ
	"SOCKET 10040 - Message too long",                          // WSAEMSGSIZE
	"SOCKET 10041 - Protocol wrong type for socket",            // WSAEPROTOTYPE
	"SOCKET 10042 - Protocol not available",                    // WSAENOPROTOOPT
	"SOCKET 10043 - Protocol not supported",                    // WSAEPROTONOSUPPORT
	"SOCKET 10044 - Socket type not supported",                 // WSAESOCKTNOSUPPORT
	"SOCKET 10045 - Operation not supported on socket",         // WSAEOPNOTSUPP
	"SOCKET 10046 - Protocol family not supported",             // WSAEPFNOSUPPORT
	"SOCKET 10047 - Address family not supported by protocol",  // WSAEAFNOSUPPORT
	"SOCKET 10048 - Address already in use",                    // WSAEADDRINUSE
	"SOCKET 10049 - Cannot assign requested address",           // WSAEADDRNOTAVAIL
	"SOCKET 10050 - Network is down",                           // WSAENETDOWN
	"SOCKET 10051 - Network is unreachable",                    // WSAENETUNREACH
	"SOCKET 10052 - Network dropped connection on reset",       // WSAENETRESET
	"SOCKET 10053 - Software caused connection abort",          // WSAECONNABORTED
	"SOCKET 10054 - Connection reset by peer",                  // WSAECONNRESET
	"SOCKET 10055 - No buffer space available",                 // WSAENOBUFS
	"SOCKET 10056 - Socket is already connected",               // WSAEISCONN
	"SOCKET 10057 - Socket is not connected",                   // WSAENOTCONN
	"SOCKET 10058 - Cannot send after socket shutdown",         // WSAESHUTDOWN
	"SOCKET 10059 - Too many references: cannot splice",
	"SOCKET 10060 - Connection timed out",                      // WSAETIMEDOUT
	"SOCKET 10061 - Connection refused",                        // WSAECONNREFUSED
	"SOCKET 10062 - Too many levels of symbolic links",
	"SOCKET 10063 - File name too long",
	"SOCKET 10064 - Host is down",                              // WSAEHOSTDOWN
	"SOCKET 10065 - No route to host",                          // WSAEHOSTUNREACH
	"SOCKET 10067 - Too many processes",                        // WSAEPROCLIM
	"SOCKET 10091 - Network subsystem is unusable",             // WSASYSNOTREADY
	"SOCKET 10092 - Winsock DLL cannot support application",    // WSAVERNOTSUPPORTED
	"SOCKET 10093 - Winsock not initialized",                   // WSANOTINITIALISED
	"SOCKET 10094 - Graceful shutdown in progress",             // WSAEDISCON
	"SOCKET 10101 - Disconnect",
	"SOCKET 10109 - Disconnect",
	"SOCKET 11001 - Type not found",                            // WSATYPE_NOT_FOUND
	"SOCKET 11002 - Nonauthoritative host not found",           // WSATRY_AGAIN
	"SOCKET 11003 - Nonrecoverable error",                      // WSANO_RECOVERY
	"SOCKET 11004 - Key (name, address, and so on) not found",  // WSANO_DATA
	"SOCKET - Timeout",
	"SOCKET - Socket closed by another thread",
	"SOCKET - Peer has closed socket",
	"SOCKET - Failed lookup of Client IP address",
	"SOCKET - Failed Event creation",
	"SOCKET - Failed starting Socket Thread",
	"SOCKET - Failed waiting for event",
	"SOCKET - Failed with an Unexpected Message",
	"SOCKET - Output Queue Full",
	"SOCKET - Undefined Error"
};

BYTE test_logical_address = 1;
BYTE test_ip[] = "127.0.0.1";


enum
{
	eVIDRequest,
	ePMRequest,
	eStatusRequest,
	eDOIPHandshake
};


// Power Mode defines
#define POWERMODENOTREADY      0x00
#define POWERMODEREADY         0x01
#define POWERMODENOTSUPPORTED  0x02

char *PowerModeStatus[] = 
{
	"Not Ready",
	"Ready",
	"Not Supported"
};


// Entity Status defines
#define DOIPGATEWAY       0x00
#define DOIPNODE          0x01

char *EntityNodeType[] = 
{
	"DoIP Gateway",
	"DoIP Node",
	"Other"
};


// Message Definitions
BYTE NACKResponse[] =
{ 0x02, 0xFD, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x04 };

BYTE VehicleIdentificationRequest[] =
{ 0xFF, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00};
//{ 0x02, 0xFD, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00 };

BYTE VehicleIdentificationRequest_WithEIN[] =
{ 0x02, 0xFD, 0x00, 0x02, 0x00, 0x00, 0x00, 0x06, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31 };

BYTE VehicleIdentificationRequest_WithVIN[] =
{ 0x02, 0xFD, 0x00, 0x03, 0x00, 0x00, 0x00, 0x11, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31 };

BYTE VehicleIdentificationResponse[] =
{ 0x02, 0xFD, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x12, 0x34, 0x31, 0x31, 0x31, 0x31, 0x31, 0x31, 0x32, 0x32, 0x32, 0x32, 0x32, 0x32, 0x00, 0x00 };


BYTE RoutingActivationRequest[] =
{ 0x02, 0xFD, 0x00, 0x05, 0x00, 0x00, 0x00, 0x0B, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

BYTE RoutingActivationRequest_WithVM[] =
{ 0x02, 0xFD, 0x00, 0x05, 0x00, 0x00, 0x00, 0x0B, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x02, 0x03, 0x04 };

BYTE RoutingActivationResponse[] =
{ 0x02, 0xFD, 0x00, 0x06, 0x00, 0x00, 0x00, 0x09, 0x0E, 0x00, 0x0E, 0x01, 0x10, 0x00, 0x00, 0x00, 0x00 };

BYTE RoutingActivationResponse_Unsuccessful[] =
{ 0x02, 0xFD, 0x00, 0x06, 0x00, 0x00, 0x00, 0x09, 0x0E, 0x00, 0x00, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00 };

BYTE RoutingActivationResponse_WithVM[] =
{ 0x02, 0xFD, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0D, 0x0E, 0x00, 0x00, 0x37, 0x10, 0x00, 0x00, 0x00, 0x00, 0x04, 0x03, 0x02, 0x01 };


BYTE AliveCheckRequest[] =
{ 0x02, 0xFD, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00 };

BYTE AliveCheckResponse[] =
{ 0x02, 0xFD, 0x00, 0x08, 0x00, 0x00, 0x00, 0x02, 0x0E, 0x00 };


BYTE EntityStatusRequest[] =
{ 0x02, 0xFD, 0x40, 0x01, 0x00, 0x00, 0x00, 0x00 };

BYTE EntityStatusResponse[] =
{ 0x02, 0xFD, 0x40, 0x02, 0x00, 0x00, 0x00, 0x03, 0x01, 0x10, 0x01 };

BYTE EntityStatusResponse_WithMDS[] =
{ 0x02, 0xFD, 0x40, 0x02, 0x00, 0x00, 0x00, 0x07, 0x01, 0x10, 0x01, 0x00, 0x00, 0x10, 0x00 };


BYTE PowerModeRequest[] =
{ 0x02, 0xFD, 0x40, 0x03, 0x00, 0x00, 0x00, 0x00 };

BYTE PowerModeResponse[] =
{ 0x02, 0xFD, 0x40, 0x04, 0x00, 0x00, 0x00, 0x01, 0x01 };


BYTE DiagnosticMsgRequest[] =
{ 0x02, 0xFD, 0x80, 0x01, 0x00, 0x00, 0x00, 0x07, 0x0E, 0x00, 0x00, 0x01, 0x00, 0x01, 0x02 };

BYTE DiagnosticMsgResult[] =
{ 0x02, 0xFD, 0x80, 0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0xE0, 0x00, 0x55, 0x00, 0x01, 0x02, 0x03 };

BYTE DiagnosticMsg_PositiveResponse[] =
{ 0x02, 0xFD, 0x80, 0x02, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00 };

BYTE DiagnosticMsg_NegativeResponse[] =
{ 0x02, 0xFD, 0x80, 0x03, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x05 };




/*******************************************************************************
**
**  Function:  ReadPacket
**
**  Purpose:   Read a packet of data from the socket
**
*******************************************************************************/
int ReadPacket ( t_stSocketData *pstSocketData,
                 BYTE           *puStaticBuffer,
                 int             iMaxBuferSize,
                 unsigned long   ulTimeout )
{
	TIMEVAL stTimeVal;
	FD_SET  stReadFD;
	FD_SET  stExceptFD;
	int     iStatus;
	int     iBytesRead;
	int     iSize = sizeof ( pstSocketData->remote_sin );


	if ( ulTimeout != 0 )
	{
		stTimeVal.tv_sec  = ulTimeout / 1000;
		stTimeVal.tv_usec = (ulTimeout % 1000) * 1000;

		FD_ZERO( &stReadFD );
		FD_SET( pstSocketData->hSock, &stReadFD );

		FD_ZERO( &stExceptFD );
		FD_SET( pstSocketData->hSock, &stExceptFD );

		// Returns when there is data to be read or/and exception or a timeout
		iStatus = select ( 1, &stReadFD, NULL, &stExceptFD, &stTimeVal );

		// If error 
		if ( iStatus == SOCKET_ERROR )
		{
			return -1 * WSAGetLastError ( );
		}

		// Timeout
		if ( iStatus == 0 )
		{
			return 0;
		}
	}


	if ( gbDirectEthernet )
	{
		iBytesRead = recv ( pstSocketData->hSock, (char*)puStaticBuffer, iMaxBuferSize, 0 );
	}
	else
	{
		iBytesRead = recvfrom ( pstSocketData->hSock, (char*)puStaticBuffer, iMaxBuferSize, 0, (struct sockaddr*)&pstSocketData->remote_sin, &iSize );
	}
	if ( iBytesRead == SOCKET_ERROR )
	{
		return -1 * WSAGetLastError ( );
	}

	return iBytesRead;
}




/*******************************************************************************
**
**  Function:  ReadSocket
**
**  Purpose:   Read data from the socket
**
*******************************************************************************/
BYTE* ReadSocket ( t_stSocketData *pstSocketData,
                   int             iHeaderSize,
                   BYTE           *puStaticBuffer,
//                   PASSTHRU_MSG   *pRxMsg,
                   WORD            *piByteCount,
//                   int             iMaxBuferSize,
                   unsigned long   ulTimeout )
{
	TIMEVAL         stTimeVal;
	FD_SET          stReadFD;
	FD_SET          stExceptFD;
	int             iStatus;
	int             iBytesRead;
	int             iByteRequest;
	int             iMinimumBytes;
	BYTE           *pucCurrentBuffer = puStaticBuffer;
//	BYTE           *pucCurrentBuffer = &pRxMsg->Data[0];
	unsigned long   ulOrigTimeout;
	boolean         bReadingMin = TRUE;
	t_stDOIPHeader *pstDOIPHeader;
	int             iMessageByteCount;

	*piByteCount = 0;
	ulOrigTimeout = ulTimeout;

	// A global data message can be read in multiple pieces.
	// The start of the message is the header which includes
	// the total byte count for the message.
	// Once the total length of the message is known,
	// the balance of the message is then read into a buffer.

	// The socket is configured as a blocking socket.
	// For an input pipe the recv() function is where the thread will primarily block.
	// When the thread needs to be stopped the recv() fill be terminated by closing the socket.

	// For output pipes the read will collect acknowledgments of sent data and heartbeat
	// messages. The read operation will have a timeout.
	// The thread should not get stuck in the blocking recv() so a timed out select call will be used
	// to determine that there is data to be read before calling the recv() function.

	// This function uses a select call to allow for a timeout on read operations.
	// A timeout value of zero will give an infinite timeout by skipping the select
	// call and reading the blocked socket.

	// The message pipe is more constrained. It uses a fixed buffer sized to the largest
	// possible single message so there is never the need to allocated for an oversized
	// message. That buffer can be packed with more that one message but those messages
	// will be in the sockets buffer and can be efficently extracted one message at a 
	// time as the read has no timeout and does not need to issue a select call before 
	// each recv call.

	iByteRequest = iHeaderSize;

	// Set the count of bytes that mark the end of the minumum size message
	iMinimumBytes = iByteRequest;

	while ( *piByteCount < iByteRequest )
	{
		// If there is a timeout we must pass the select call first so
		// that we don't get stuck in the recv function call.

		// If there is no timeout, we will block in the recv function until
		// we get data or the socket is closed
		if ( ulTimeout != 0 )
		{
			stTimeVal.tv_sec  = ulTimeout / 1000;
			stTimeVal.tv_usec = (ulTimeout % 1000) * 1000;

			FD_ZERO( &stReadFD );
			FD_SET( pstSocketData->hSock, &stReadFD );

			FD_ZERO( &stExceptFD );
			FD_SET( pstSocketData->hSock, &stExceptFD );

			// Returns when there is data to be read or and exception or a timeout
			iStatus = select ( 1, &stReadFD, NULL, &stExceptFD, &stTimeVal );

			// If error
			if ( iStatus == SOCKET_ERROR )
			{
				pstSocketData->iError = WSAGetLastError ( );

				return NULL;
			}

			// Timeout
			if ( iStatus == 0 )
			{
				pstSocketData->iError = eSocketTimeout;

				return NULL;
			}
		}

		// Ask for the balance of the message.
		// For the first pass this is the size of the minimum message.
		// After we know the message length the remaining data of the message is loaded
		iBytesRead = recv ( pstSocketData->hSock, (char*)&pucCurrentBuffer[*piByteCount], iByteRequest - *piByteCount, 0 );

		if ( iBytesRead == SOCKET_ERROR )
		{
			pstSocketData->iError = WSAGetLastError ( );

			return NULL;
		}

		// Closing the socket in another thread can cause the recv function
		// to return a byte count of zero
		if ( iBytesRead == 0 )
		{
			pstSocketData->iError = eSocketConnectionClosing;

			return NULL;
		}

		*piByteCount += iBytesRead;
		// It is possible that this takes multiple reads before we have 
		// assembled the entire header
		if ( *piByteCount == iMinimumBytes &&
		     bReadingMin )
		{
			// The first eight bytes of any of the message types is a DoIP header
			// with an additional byte count
			pstDOIPHeader = (t_stDOIPHeader*)pucCurrentBuffer;

			iMessageByteCount = ntohl(pstDOIPHeader->ulLength) + sizeof ( t_stDOIPHeader );

			// The minimum message could be the complete message
			if ( iMessageByteCount == *piByteCount )
			{
				return pucCurrentBuffer;
			}
			else
			{
				bReadingMin = FALSE;

				// Get the count of the balance of the message
				iByteRequest = iMessageByteCount;

				// Global messages are processed using static buffer sized near the size of the IP packet.
				// There is nothing in the data definitions that precludes a larger data item from being
				// transfered on the pipe. For data messages that are larger than the default static
				// buffer, allocate a buffer. The downstream processing will recognize an allocated buffer
				// and free it on completion of message processing.
				if ( iMessageByteCount > MAX_MSG_LEN )
				{
					pucCurrentBuffer = calloc ( 1, iMessageByteCount );

					memcpy ( pucCurrentBuffer, puStaticBuffer, *piByteCount );
//					memcpy ( pucCurrentBuffer, &pRxMsg->Data[0], *piByteCount );
				}
			}  // end if ( iMessageByteCount != iByteCount )
		}  // end if ( iByteCount == iMinimumBytes && bReadingMin )
	}  // end while ( iByteCount < iByteRequest )

	return pucCurrentBuffer;
}




/*******************************************************************************
**
**  Function:  WriteSocket
**
**  Purpose:   Write data to the socket
**
*******************************************************************************/
BOOL WriteSocket ( t_stSocketData *pstSocketData,
                   BYTE           *pucCommand,
                   int             iCommandLen,
                   unsigned long   ulTimeout )
{
	TIMEVAL stTimeVal;
	FD_SET  stWriteFD;
	FD_SET  stExceptFD;
	int     iStatus;
	int     iBytesWritten;
	int     iTotalBytes = 0;

	// It can take several passes to send the messaage if the connection is blocking.
	// If there is a timeout value it will apply to each portition of the message that is sent.
	do
	{
		// The connection is setup with a blocking socket.
		// We don't want to get stuck waiting forever to write so we use a select command
		// to see if the connection is clear to send or has an error.
		if ( ulTimeout != 0 )
		{
			// If there is a timeout we must pass the select call first so
			// that we don't get stuck in the send function call. 
			stTimeVal.tv_sec  = ulTimeout / 1000;
			stTimeVal.tv_usec = ulTimeout % 1000;

			FD_ZERO( &stWriteFD );
			FD_SET( pstSocketData->hSock, &stWriteFD );

			FD_ZERO( &stExceptFD );
			FD_SET( pstSocketData->hSock, &stExceptFD );

			iStatus = select ( 1, NULL, &stWriteFD, &stExceptFD, &stTimeVal );
			// If error
			if ( iStatus == SOCKET_ERROR )
			{
				pstSocketData->iError = WSAGetLastError ( );
				return FALSE;
			}
			// If Timeout
			else if ( iStatus == 0 )
			{
				// Any timeout on send closes the socket
				pstSocketData->iError = eSocketTimeout;
				return FALSE;
			}
		}

		// Setup the address for the the broadcast request
		SOCKADDR_IN     remote_sin;
		remote_sin.sin_family           = AF_INET;
		remote_sin.sin_addr.S_un.S_addr = INADDR_BROADCAST;
		remote_sin.sin_port             = htons(13400);
		iBytesWritten = sendto ( pstSocketData->hSock, (char*)&pucCommand[iTotalBytes], iCommandLen - iTotalBytes, 0, (SOCKADDR*)&remote_sin, sizeof ( remote_sin ) );
//		iBytesWritten = send ( pstSocketData->hSock, (char*)&pucCommand[iTotalBytes], iCommandLen - iTotalBytes, 0 );
		if ( iBytesWritten == SOCKET_ERROR )
		{
			pstSocketData->iError = WSAGetLastError ( );
			return FALSE;
		}

		// Update the total number of byte send
		iTotalBytes += iBytesWritten;
	}
	// Continue to send pieces of the message until the entire byte array has been sent.
	while ( iCommandLen > iTotalBytes );

	return TRUE;
}




/*******************************************************************************
**
**  Function:  GetEthernetErrorString
**
**  Purpose:   Return a pointer to the Error String corresponding to
**             the passed Error number
**
*******************************************************************************/
char* GetEthernetErrorString ( int iError )
{
	int i;

	for ( i = 0;
	      i < NUM_SOCKET_ERRORS;
	      i++)
	{
		if ( iError == ausSocketErrors[i] )
		{
			return aszSocketErrorDescriptions[i];
		}
	}

	return aszSocketErrorDescriptions[eMaxSocketErrorCodes];
}




/*******************************************************************************
**
**  Function:  FindVehicle
**
**  Purpose:   
**
*******************************************************************************/
void FindVehicle ( t_stSocketData *pstSocketData )
{
	SOCKADDR_IN     remote_sin;
	int             iBytesWritten;
	int             iBytesRead;
	BYTE            aucReadMessage[PACKET_SIZE];

	BYTE            DoIPIndex;
	BYTE            IPIndex;
	BYTE            ByteIdx;
	char            DataString[PACKET_SIZE*3];
	char            TextString[200];

	boolean         bRsp = FALSE;
	BYTE            ReadAttempts;
	BYTE            WriteAttempts;

	// In C, as opposed to C++, global static definitions cannot include function calls, so the initialization cannot use htons();
	// Initialization of automatic variables in a function can use htons, so each thread could have a copy of these definitions,
	// using structure initialization, but a single copy used by all threads must be initialized as byte arrays.
	BYTE astDOIPRequests[eDOIPHandshake][sizeof(t_stDOIPHeader)] =
	{
		{0xFF, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00},  // Vehicle Identification Request
		{0x02, 0xFD, 0x40, 0x03, 0x00, 0x00, 0x00, 0x00},  // Power Mode Request
		{0x02, 0xFD, 0x40, 0x01, 0x00, 0x00, 0x00, 0x00}   // DoIP Entity Status Request
	};
	BYTE astDOIPResponses[eDOIPHandshake][sizeof(t_stDOIPHeader)] =
	{
		{0x02, 0xFD, 0x00, 0x04, 0x00, 0x00, 0x00, 0x21},  // Vehicle Announcement Message/Vehicle Identification Response
		{0x02, 0xFD, 0x40, 0x04, 0x00, 0x00, 0x00, 0x01},  // Power Mode Response
		{0x02, 0xFD, 0x40, 0x02, 0x00, 0x00, 0x00, 0x07}   // DoIP Entity Status Response
	};


	// Setup the address for the the broadcast request
	remote_sin.sin_family           = AF_INET;
	remote_sin.sin_addr.S_un.S_addr = INADDR_BROADCAST;
	remote_sin.sin_port             = htons(13400);

	Log ( BLANK, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
	      "\n" );

	for ( DoIPIndex = 0;
	      DoIPIndex < eDOIPHandshake;
	      DoIPIndex++ )
	{
		bRsp = FALSE;
		ReadAttempts = 0;
		WriteAttempts = 0;
		do
		{
			// Check to see if the vehicle was found on another address or
			// if the operation is aborted
			if ( pstSocketData->bStop )
			{
				pstSocketData->lThread = -1;

				return;
			}

			if ( gbDirectEthernet )
			{
				iBytesWritten = send ( pstSocketData->hSock, (char*)&astDOIPRequests[DoIPIndex], sizeof ( t_stDOIPHeader ), 0 );
			}
			else
			{
				iBytesWritten = sendto ( pstSocketData->hSock, (char*)&astDOIPRequests[DoIPIndex], sizeof ( t_stDOIPHeader ), 0, (SOCKADDR*)&remote_sin, sizeof ( remote_sin ) );
			}
			if ( iBytesWritten != sizeof ( t_stDOIPHeader ) )
			{
				pstSocketData->iError  = WSAGetLastError ( );
				pstSocketData->lThread = -1;

				return;
			}
			WriteAttempts++;

			if ( DoIPIndex == eVIDRequest )
			{
				sprintf_s ( TextString, 200,
				            "Vehicle Identification Request" );
			}
			else if ( DoIPIndex == ePMRequest )
			{
				sprintf_s ( TextString, 200,
				            "Power Mode Request" );
			}
			else if ( DoIPIndex == eStatusRequest )
			{
				sprintf_s ( TextString, 200,
				            "Entity Status Request" );
			}
			Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "%s  sent to  %d.%d.%d.%d\n",
			      TextString,
			      remote_sin.sin_addr.S_un.S_un_b.s_b1,
			      remote_sin.sin_addr.S_un.S_un_b.s_b2,
			      remote_sin.sin_addr.S_un.S_un_b.s_b3,
			      remote_sin.sin_addr.S_un.S_un_b.s_b4 );

			DataString[0] = (BYTE)NULL;
			for ( ByteIdx = 0;
			      ByteIdx < iBytesWritten;
			      ByteIdx++ )
			{
				sprintf_s ( &DataString[strlen (DataString)], (PACKET_SIZE*3) - strlen ( DataString ),
				            "%02X ",
				            astDOIPRequests[DoIPIndex][ByteIdx] );
			}
//			String[strlen (String)] = (BYTE)NULL;

			Log ( NETWORK, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "TX MSG: %10luusec %s %s\n",
			      GetTickCount(),
			      gstProtocolList[gProtocolIdx].eProtocol == DOIP ? "DOIP" : "DOIP_NDIS",
			      DataString );

			do
			{
				iBytesRead = ReadPacket ( pstSocketData, aucReadMessage, sizeof ( aucReadMessage ), DOIP_TIMEOUT );
				if ( iBytesRead < 0 )
				{
					pstSocketData->iError  = -iBytesRead;
					pstSocketData->lThread = -1;

					return;
				}
				else if ( iBytesRead > 0 )
				{
					DataString[0] = (BYTE)NULL;
					for ( ByteIdx = 0;
					      ByteIdx < iBytesRead;
					      ByteIdx++ )
					{
						sprintf_s ( &DataString[strlen (DataString)], (PACKET_SIZE*3) - strlen ( DataString ),
						            "%02X ",
						            aucReadMessage[ByteIdx] );
					}
//					String[strlen (String)] = (BYTE)NULL;

					Log ( NETWORK, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
					      "RX MSG: %10luusec %s %s  recvd from  %d.%d.%d.%d\n",
					      GetTickCount(),
					      gstProtocolList[gProtocolIdx].eProtocol == DOIP ? "DOIP" : "DOIP_NDIS",
					      DataString,
					      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b1,
					      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b2,
					      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b3,
					      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b4 );

					if ( pstSocketData->remote_sin.sin_addr.S_un.S_addr != pstSocketData->ulAddress &&
					     pstSocketData->remote_sin.sin_addr.S_un.S_addr != INADDR_BROADCAST )
					{
						// check if this IP Address is already in the list
						for ( IPIndex = 0;
						      IPIndex < IPAddressInfoCount && IPIndex < MAX_IP_ADDRESSES;
						      IPIndex++ )
						{
							if ( IPAddressInfo[IPIndex].ulIPv4Address == pstSocketData->remote_sin.sin_addr.S_un.S_addr )
							{
								break;
							}
						}
						if ( IPIndex == IPAddressInfoCount )
						{
							IPAddressInfo[IPIndex].ulIPv4Address = pstSocketData->remote_sin.sin_addr.S_un.S_addr;
							IPAddressInfoCount++;
						}
					}

					// if loopback, ignore it
					if ( stSocketData.ulAddress == stSocketData.remote_sin.sin_addr.S_un.S_addr )
					{
						Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
						      "Loopback of Request  rcvd\n" );
						continue;
					}

//					if ( memcmp ( (BYTE*)&astDOIPResponses[DoIPIndex], aucReadMessage, sizeof ( t_stDOIPHeader ) ) == 0 )
					if ( memcmp ( (BYTE*)&astDOIPResponses[DoIPIndex], aucReadMessage, sizeof ( t_stDOIPHeader )-1 ) == 0 )
					{
						if ( DoIPIndex == eVIDRequest )
						{
							t_sVIDResponse *psVIDResponse = (t_sVIDResponse*)&aucReadMessage;

							memcpy ( gVIDString, psVIDResponse->Info.acVIN, 17 );
							gVIDString[17] = (char)NULL;

							Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
							      "Vehicle Identification Response from %d.%d.%d.%d:\n"
							      "                                VIN: \"%s\"\n"
							      "                                Logical Address: %04X\n"
							      "                                EID: %d.%d.%d.%d.%d.%d\n"
							      "                                GID: %d.%d.%d.%d.%d.%d\n"
							      "                                Action: %02X\n\n",
							      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b1,
							      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b2,
							      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b3,
							      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b4,
							      gVIDString,
							      _byteswap_ushort( psVIDResponse->Info.usLogicalAddress ),
							      psVIDResponse->Info.aucEID[0], psVIDResponse->Info.aucEID[1],
							      psVIDResponse->Info.aucEID[2], psVIDResponse->Info.aucEID[3],
							      psVIDResponse->Info.aucEID[4], psVIDResponse->Info.aucEID[5],
							      psVIDResponse->Info.aucGID[0], psVIDResponse->Info.aucGID[1],
							      psVIDResponse->Info.aucGID[2], psVIDResponse->Info.aucGID[3],
							      psVIDResponse->Info.aucGID[4], psVIDResponse->Info.aucGID[5],
							      psVIDResponse->Info.ucAction );
						}
						else if ( DoIPIndex == ePMRequest )
						{
							t_stPMResponse *psPMResponse = (t_stPMResponse*)&aucReadMessage;

							Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
							      "Power Mode Response from %d.%d.%d.%d:\n"
							      "                    Mode: %d (%s)\n\n",
							      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b1,
							      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b2,
							      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b3,
							      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b4,
							      psPMResponse->ucMode,
							      PowerModeStatus[psPMResponse->ucMode] );
						}

						else if ( DoIPIndex == eStatusRequest )
						{
							t_stStatusResponse *psStatusResponse = (t_stStatusResponse*)&aucReadMessage;

							Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
							      "Entity Status Response from %d.%d.%d.%d:\n"
							      "                       Node Type:     %d (%s)\n"
							      "                       Max Sockets:   %d\n"
							      "                       Open Sockets:  %d\n"
							      "                       Max Data Size: %ld\n\n",
							      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b1,
							      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b2,
							      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b3,
							      pstSocketData->remote_sin.sin_addr.S_un.S_un_b.s_b4,
							      psStatusResponse->Info.ucNodeType,
							      EntityNodeType[psStatusResponse->Info.ucNodeType],
							      psStatusResponse->Info.ucMaxSockets,
							      psStatusResponse->Info.ucOpenSockets,
							      _byteswap_ulong( psStatusResponse->Info.ulMaxSize ) );

							if ( psStatusResponse->Info.ucMaxSockets == 0 )
							{
								Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
								      "Entity Status Response Error: Must have at least 1 socket available\n\n" );
							}

							pstSocketData->bConnected = TRUE;
							pstSocketData->lThread = -1;
//							return;
						}

						bRsp = TRUE;
						ReadAttempts = 0;

					}  // end if ( memcmp )
				}  // end if ( iBytesRead > 0 )
				else
				{
					ReadAttempts++;
				}
			}
			while ( iBytesRead > 0 ||
			        ReadAttempts < MAX_READ_ATTEMPTS );
		}
		while ( !bRsp &&
		        WriteAttempts < MAX_WRITE_ATTEMPTS );
	}  // end for ( i < eDOIPHandshake )

	pstSocketData->lThread = -1;
}




/*******************************************************************************
**
**  Function:  RoutingActivation
**
**  Purpose:   Write the Routing Activation Request to the socket and read the reply
**
*******************************************************************************/
STATUS RoutingActivation ( )
{
	int   iBytesRead;
	BYTE  aucReadMessage[PACKET_SIZE];
	boolean bRsp = FALSE;
	BYTE  Responses = 0;
	BYTE  ReadAttempts = 0;
	BYTE  WriteAttempts = 0;

	WORD  ByteIdx;
	char  DataString[PACKET_SIZE*3];
	char *pErrorString;


//	// check if this IP Address is already in the list
//	for ( BYTE IPIndex = 0;
//	      IPIndex < IPAddressInfoCount && IPIndex < MAX_IP_ADDRESSES;
//	      IPIndex++ )
//	{
//		if ( IPAddressInfo[IPIndex].ulIPv4Address == pstSocketData->remote_sin.sin_addr.S_un.S_addr )
//		{
//			break;
//		}
//	}
//	if ( IPIndex == IPAddressInfoCount )
//	{
//		IPAddressInfo[IPIndex].ulIPv4Address = pstSocketData->remote_sin.sin_addr.S_un.S_addr;
//		IPAddressInfoCount++;
//	}
	do
	{
		// Send Routing Activation Request
		if ( !WriteSocket ( &stSocketData, (BYTE*)&RoutingActivationRequest, sizeof ( RoutingActivationRequest ), DOIP_TIMEOUT ) )
		{
			pErrorString = GetEthernetErrorString ( stSocketData.iError );
			Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "Routing Activation Request Error: %d: %s\n",
			      stSocketData.iError,
			      pErrorString );
			return FAIL;
		}
		WriteAttempts++;

		Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
		      "Routing Activation Request sent\n" );
	
		DataString[0] = (BYTE)NULL;
		for ( ByteIdx = 0;
		      ByteIdx < sizeof ( RoutingActivationRequest );
		      ByteIdx++ )
		{
			sprintf_s ( &DataString[strlen (DataString)], (PACKET_SIZE*3) - strlen ( DataString ),
			            "%02X ",
			            RoutingActivationRequest[ByteIdx] );
		}
//		String[strlen (String)] = (BYTE)NULL;
	
		Log ( NETWORK, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
		      "TX MSG: %10luusec %s %s\n",
		      GetTickCount(),
		      gstProtocolList[gProtocolIdx].eProtocol == DOIP ? "DOIP" : "DOIP_NDIS",
		      DataString );
	
		// Read Routing Activation Resoponse
		do
		{
//			if ( gbDirectEthernet )
			{
				iBytesRead = ReadPacket ( &stSocketData, aucReadMessage, sizeof ( aucReadMessage ), DOIP_TIMEOUT );
			}
//			else
//			{
//				ReadSocket ( &stSocketData, sizeof ( RoutingActivationResponse ), aucReadMessage, (WORD *)&iBytesRead, DOIP_TIMEOUT );
//			}
			if ( iBytesRead < 0 )
			{
				pErrorString = GetEthernetErrorString ( stSocketData.iError );
				Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
				      "Routing Activation Response Error: %d: %s\n",
				      stSocketData.iError,
				      pErrorString );
				return FAIL;
			}
	
			else if ( iBytesRead > 0 )
			{
				DataString[0] = (BYTE)NULL;
				for ( ByteIdx = 0;
				      ByteIdx < iBytesRead;
				      ByteIdx++ )
				{
					sprintf_s ( &DataString[strlen (DataString)], (PACKET_SIZE*3) - strlen ( DataString ),
					            "%02X ",
					            aucReadMessage[ByteIdx] );
				}
//				DataString[strlen (DataString)] = (BYTE)NULL;
	
				Log ( NETWORK, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
				      "RX MSG: %10luusec %s %s  recvd from  %d.%d.%d.%d\n",
				      GetTickCount(),
				      gstProtocolList[gProtocolIdx].eProtocol == DOIP ? "DOIP" : "DOIP_NDIS",
				      DataString,
				      stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b1,
				      stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b2,
				      stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b3,
				      stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b4 );
	
				// if loopback, ignore it
				if ( stSocketData.ulAddress == stSocketData.remote_sin.sin_addr.S_un.S_addr )
				{
					Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
					      "Loopback of Request rcvd\n" );
				}

				else if ( memcmp ( (BYTE*)&RoutingActivationResponse, aucReadMessage, sizeof ( t_stDOIPHeader ) ) == 0 )
				{
					t_stActivationResponse *psActivationResponse = (t_stActivationResponse *)aucReadMessage;
	
					Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
					      "Routing Activation Response from %d.%d.%d.%d:\n"
					      "                            DoIP Address:   $%04X\n"
					      "                            Response Code:  $%02X\n\n",
					      stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b1,
					      stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b2,
					      stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b3,
					      stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b4,
					      _byteswap_ushort( psActivationResponse->Info.usSourceAddress ),
					      psActivationResponse->Info.ucAtivationResponse );
	
					bRsp = TRUE;
					Responses++;
					ReadAttempts = 0;
					
					// if using ini DID list (instead of $F810), use these responses for Num of ECU count
//					if ( gTestDIDCount != 0 )
//					{
//						gNumOfECUsResp++;
//					}
				}
				else
				{
//					Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
//					      "Improper Routing Activation Response\n" );
//					return FAIL;
				}
			}
			else
			{
				ReadAttempts++;
			}
		}
//		while ( iBytesRead > 0 );
		while ( Responses < gUserNumOfECUs &&
		        ReadAttempts < MAX_READ_ATTEMPTS );
	}
	while ( !bRsp &&
	        WriteAttempts < MAX_WRITE_ATTEMPTS );

	Log ( BLANK, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
	      "\n" );

//	if ( gTestDIDCount != 0 )
//	{
//		gNumOfECUs = gNumOfECUsResp;
//	}

	return PASS;
}




/*******************************************************************************
**
**  Function:  OpenChannel
**
**  Purpose:   
**
*******************************************************************************/
long OpenChannel ( unsigned long  ulTesterAddress,
                   char          *pcTesterAddress,
                   char          *pcVehicleAddress,
                   unsigned short usTesterPort,
                   unsigned short usTesterAddres )
{
	WSADATA        WSAData;
	SOCKADDR_IN    source_sin;
	SOCKADDR_IN    remote_sin;
	DWORD          timeout;
	BOOL           bNoDelay = TRUE;
	boolean        bBroadcast = TRUE;
	LINGER         stLinger;
	unsigned long  ulVehicleAddress = 0;
	int            iConnected = -1;
	int            iRetval;
	char          *pErrorString;


	// The stream socket will get cleaned up outside of this function so
	// initialize the socket field to indicate that it has not yet been configured and
	// therefor does not have to be cleaned up
	stSocketData.hSock = INVALID_SOCKET;


	// Is there a vehicle address?
	if ( pcVehicleAddress )
	{
		iRetval = inet_pton ( AF_INET, pcVehicleAddress, &ulVehicleAddress );
		if ( iRetval == 0 )
		{
			// Invalid address format
			Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "Invalid Vehicle Address\n" );
			return -1;
		}

		if ( iRetval < 0 )
		{
			return WSAGetLastError ( );
		}

		if ( iRetval == 1 )
		{
			// Stop the address loop and signal nothing to clean up
			iConnected = -2;
		}
	}


	/**********************************************************************
	*    start Windows sockets
	**********************************************************************/
	if ( gbDirectEthernet )
	{
		if ( WSAStartup ( MAKEWORD(1, 1), &WSAData ) != 0 )
		{
			fprintf ( stderr, "WSAStartup failed.\n" );
			return 0;
		}

		// socket create and verification
		stSocketData.hSock = socket ( AF_INET,
		                              SOCK_STREAM,
		                              0 );
		if ( stSocketData.hSock == INVALID_SOCKET )
		{
			printf ( "Socket creation failed.\n" );
			return WSAGetLastError ( );
		}
		else
		{
			printf ( "Socket successfully created.\n" );
		}

		memset ( &source_sin, 0, sizeof(source_sin) );
		// assign IP, PORT
		source_sin.sin_family      = AF_INET;
		source_sin.sin_addr.s_addr = inet_addr ( "127.0.0.1" );
//		source_sin.sin_addr.s_addr = inet_pton ( AF_INET, "192.168.171.100", &serveraddress );
//		source_sin.sin_port        = htons ( PORT );
//		source_sin.sin_addr.s_addr = inet_addr ( "192.168.171.100" );
//		source_sin.sin_addr.s_addr = inet_addr ( gVehicleIPv4AddressString );
		source_sin.sin_port        = htons ( TESTERPORT );

		ulTesterAddress = source_sin.sin_addr.s_addr;
 
		// connect the client socket to server socket
		if ( connect ( stSocketData.hSock, (struct sockaddr*)&source_sin, sizeof(source_sin) ) != 0)
		{
			printf ( "Connection to the server failed.\n" );
			stSocketData.iError  = WSAGetLastError ( );
			stSocketData.lThread = -1;
			return WSAGetLastError ( );
		}
		else
		{
			printf ( "Connected to the server.\n" );
		}

		timeout = 100;
		
		if ( setsockopt ( stSocketData.hSock, SOL_SOCKET, SO_RCVTIMEO, (const char*)&timeout, sizeof (timeout)) < 0 )
		{
			printf ( "setsockopt SO_RCVTIMEO failed\n" );
			stSocketData.iError  = WSAGetLastError ( );
			stSocketData.lThread = -1;
		}
		
		if ( setsockopt ( stSocketData.hSock, SOL_SOCKET, SO_SNDTIMEO, (const char*)&timeout, sizeof (timeout)) < 0 )
		{
			printf ( "setsockopt SO_SNDTIMEO failed\n" );
			stSocketData.iError  = WSAGetLastError ( );
			stSocketData.lThread = -1;
		}
//		DWORD m = 1;
//		ioctlsocket ( sockfd, FIONBIO, &m );

	}
	else
	{
		if ( !bNetworkStarted )
		{
			if ( WSAStartup ( MAKEWORD(2, 2), &WSAData ) )
			{
				stSocketData.iError  = WSAGetLastError ( );
				stSocketData.lThread = -1;
				return WSAGetLastError ( );
			}

			bNetworkStarted = TRUE;
		}

		// Is there a client address
		if ( pcTesterAddress )
		{
			iRetval = inet_pton ( AF_INET, pcTesterAddress, &ulTesterAddress );

			if ( iRetval == 0 )
			{
				// Invalid address format
				return -1;
			}

			if ( iRetval < 0 )
			{
				stSocketData.iError  = WSAGetLastError ( );
				stSocketData.lThread = -1;
				return WSAGetLastError ( );
			}
		}

		// Create a socket
		stSocketData.hSock = socket ( AF_INET, SOCK_DGRAM, 0 );
		if ( stSocketData.hSock == INVALID_SOCKET )
		{
			stSocketData.iError  = WSAGetLastError ( );
			stSocketData.lThread = -1;
			return WSAGetLastError ( );
		}

		source_sin.sin_family           = AF_INET;
//		source_sin.sin_addr.S_un.S_addr = stSocketData.ulAddress;
		source_sin.sin_addr.S_un.S_addr = ulTesterAddress;
		source_sin.sin_port             = htons(13400);

		// Enable broadcasts on the socket
		setsockopt ( stSocketData.hSock, SOL_SOCKET, SO_BROADCAST, (char*)&bBroadcast, sizeof(BOOL) );
		
		// Bind the socket to the client address
		if ( bind ( stSocketData.hSock, (struct sockaddr*)&source_sin, sizeof ( source_sin ) ) == SOCKET_ERROR )
		{
			stSocketData.iError  = WSAGetLastError ( );
			stSocketData.lThread = -1;
			return WSAGetLastError ( );
		}
	}


	// if there are both a tester and vehicle address
//	if ( ulTesterAddress  != 0 &&
//	     ulVehicleAddress != 0 )
	if ( ulTesterAddress  != 0 )
	{
		stSocketData.ulAddress = ulTesterAddress;
		stSocketData.lThread   = -1;

		FindVehicle ( &stSocketData );

		if ( stSocketData.hSock == INVALID_SOCKET )
		{
			pErrorString = GetEthernetErrorString ( stSocketData.iError );
			Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "Find Vehicle Error: %s\n",
			      pErrorString );

			// failed to start the known client address socket
			return -1;
		}

		if ( !gbDirectEthernet )
//		if ( 0 )
		{
			// Wait for the server to be responsive or if there is an error (SHOULD BE AN EVENT?)
			do
			{
				Sleep ( 10 );
			}
			while ( stSocketData.lThread != -1 );

			if ( stSocketData.hSock != INVALID_SOCKET )
			{
				closesocket ( stSocketData.hSock );
			}

			if ( stSocketData.bConnected )
			{
				ulVehicleAddress = stSocketData.remote_sin.sin_addr.S_un.S_addr;
				iConnected = -2;
			}
			else
			{
				// failure on the known client address socket
				return -1;
			}


			// Is this thread still running
			if ( stSocketData.lThread != -1 )
			{
				// set the flag that will abort the thread loop
				stSocketData.bStop = TRUE;

				// close the socket to end a blocked read of the socket
				closesocket ( stSocketData.hSock );
			}

			if ( iConnected == -1 )
			{
				// Exited the loop with a failure
				return -1;
			}

			source_sin.sin_family           = AF_INET;
			source_sin.sin_addr.S_un.S_addr = ulTesterAddress;
			source_sin.sin_port             = htons(usTesterPort);

			remote_sin.sin_family           = AF_INET;
			remote_sin.sin_addr.S_un.S_addr = ulVehicleAddress;
			remote_sin.sin_port             = htons(13400);

			stSocketData.hSock = socket ( AF_INET, SOCK_STREAM, 0 );

			if ( stSocketData.hSock == INVALID_SOCKET )
			{
				return WSAGetLastError();
			}

			setsockopt ( stSocketData.hSock, IPPROTO_TCP, TCP_NODELAY, (char*)&bNoDelay, sizeof ( BOOL ) );

			stLinger.l_linger = 0;
			stLinger.l_onoff  = TRUE;

			setsockopt ( stSocketData.hSock, SOL_SOCKET, SO_LINGER, (char*)&stLinger, sizeof ( LINGER ) );

			if ( bind ( stSocketData.hSock, (struct sockaddr*)&source_sin, sizeof ( source_sin ) ) == SOCKET_ERROR )
			{
				return WSAGetLastError ( );
			}


			// loop on connect if server is not ready
			if ( connect ( stSocketData.hSock, (struct sockaddr*)&remote_sin, sizeof ( remote_sin ) ) == SOCKET_ERROR )
			{
				return WSAGetLastError ( );
			}
		}
	}

	return 0;
}




/*******************************************************************************
**
**  Function:  StartDoIPChannel
**
**  Purpose:   
**
*******************************************************************************/
int StartDoIPChannel ( BYTE *pTAddress, BYTE *pVAddress )
{
	long           lRet;
	char           TesterIPAddress[MAX_IPV4_ADDRESS_STRING_LENGTH];
	char          *pcTesterIPAddress = NULL;  // address is unknown
//	char          *pcTesterIPAddress = acTesterAddress;
	char           VehicleIPAddress[MAX_IPV4_ADDRESS_STRING_LENGTH];
	char          *pcVehicleIPAddress = NULL;  // address is unknown
//	char          *pcVehicleIPAddress = acVehicleAddress;
	unsigned short usTesterIPPort    = 13400;
	unsigned short usTesterAddress   = 0x0E00;
	char          *pErrorString;


	if ( pTAddress != NULL )
	{
		sprintf_s ( TesterIPAddress, sizeof ( TesterIPAddress ),
		            "%d.%d.%d.%d",
		            pTAddress[0],
		            pTAddress[1],
		            pTAddress[2],
		            pTAddress[3] );
		pcTesterIPAddress = &TesterIPAddress[0];
	}

	if ( pVAddress != NULL )
	{
		sprintf_s ( VehicleIPAddress, sizeof ( VehicleIPAddress ),
		            "%d.%d.%d.%d",
		            pVAddress[0],
		            pVAddress[1],
		            pVAddress[2],
		            pVAddress[3] );
		pcVehicleIPAddress = &VehicleIPAddress[0];
	}


//	if ( gbDirectEthernet )
//	{
//		StartSocket();
//	}
//	else
	{
		if ( (lRet = OpenChannel ( 0, pcTesterIPAddress, pcVehicleIPAddress, usTesterIPPort, usTesterAddress )) != 0 )
//		if ( (lRet = OpenChannel ( 0, NULL,              NULL,               usTesterIPPort, usTesterAddress )) != 0 )
		{
			pErrorString = GetEthernetErrorString ( stSocketData.iError );
			Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "Open Channel Error: %d: %s\n",
			      stSocketData.iError,
			      pErrorString );
			return FAIL;
		}

	}

	RoutingActivation ( );

	return PASS;
}




/*******************************************************************************
**
**  Function:  ReadDoIPMsg
**
**  Purpose:   
**
*******************************************************************************/
STATUS ReadDoIPMsg ( PASSTHRU_MSG *pRxMsg, WORD *pMsgCnt )
{
//	char *pReadBuf;
	WORD  ByteIdx;
	char  DataString[PACKET_SIZE*3];
	char *pErrorString;

//	if ( (pReadBuf = ReadSocket ( &stSocketData, sizeof ( t_stDOIPHeader ), pRxMsg, DOIP_TIMEOUT )) == NULL )
	pRxMsg->DataSize = ReadPacket ( &stSocketData, &pRxMsg->Data[0], sizeof ( pRxMsg->Data ), DOIP_TIMEOUT );
	if ( pRxMsg->DataSize < 0 )
	{
		pErrorString = GetEthernetErrorString ( stSocketData.iError );
		Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
		      "Read Socket Error: %d: %s\n",
		      stSocketData.iError,
		      pErrorString );
		*pMsgCnt = 0;
		return FAIL;
	}

	else if ( pRxMsg->DataSize > 0 )
	{
		if ( stSocketData.ulAddress == stSocketData.remote_sin.sin_addr.S_un.S_addr )
		{
			DataString[0] = (BYTE)NULL;
			for ( ByteIdx = 0;
			      ByteIdx < pRxMsg->DataSize;
			      ByteIdx++ )
			{
				sprintf_s ( &DataString[strlen (DataString)], (PACKET_SIZE*3) - strlen ( DataString ),
				            "%02X ",
				            pRxMsg->Data[ByteIdx] );
			}
//			DataString[strlen (DataString)] = (BYTE)NULL;
			
			Log ( NETWORK, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "RX MSG: %10luusec %s %s  recvd from  %d.%d.%d.%d\n",
			      GetTickCount(),
			      gstProtocolList[gProtocolIdx].eProtocol == DOIP ? "DOIP" : "DOIP_NDIS",
			      DataString,
			      stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b1,
			      stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b2,
			      stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b3,
			      stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b4 );

			Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "Loopback of Request  rcvd\n" );
		}
		else
		{
			sprintf_s ( RcvdIPAddress, sizeof (RcvdIPAddress),
			            "%d.%d.%d.%d",
			            stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b1,
			            stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b2,
			            stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b3,
			            stSocketData.remote_sin.sin_addr.S_un.S_un_b.s_b4 );
		}

		pRxMsg->eProtocolID    = gstProtocolList[gProtocolIdx].eProtocol;
		if ( stSocketData.ulAddress == stSocketData.remote_sin.sin_addr.S_un.S_addr )
		{
			pRxMsg->RxStatus       = TX_MSG_TYPE;
		}
		else
		{
			pRxMsg->RxStatus       = 0;
		}
		pRxMsg->TxFlags        = 0;
		pRxMsg->TimestampMsecs = GetTickCount ( );
		pRxMsg->ExtraDataIndex = MAX_MESSAGE_LOG_SIZE;
	}

	else
	{
		*pMsgCnt = 0;
	}

	return PASS;
}




/*******************************************************************************
**
**  Function:  WriteDoIPMsg
**
**  Purpose:   
**
*******************************************************************************/
STATUS WriteDoIPMsg ( BYTE *pBuf, WORD BufLen )
{
	char *pErrorString;

//	if ( gbDirectEthernet )
//	{
//		WriteSocket_s ( pBuf, BufLen );
//	}
//	else
	{
		if ( !WriteSocket ( &stSocketData, pBuf, BufLen, DOIP_TIMEOUT ) )
		{
			pErrorString = GetEthernetErrorString ( stSocketData.iError );
			Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "Write Socket Error: %d %s\n",
			      stSocketData.iError,
			      pErrorString );
			return FAIL;
		}
	}
	return PASS;
}


/*******************************************************************************
**
**  Function:  getDecimalValueOfIPAddressString
**
**  Purpose:   Convert an IP Address text string into a byte array and an unsigned long single value
**
*******************************************************************************/
DWORD getDecimalValueOfIPAddressString ( BYTE *pIPAddress, char *pIPAddressString )
{
	BYTE i = 0;  // string index
	BYTE j = 0;  // decimal number index
	
	pIPAddress[j] = 0;
	while ( pIPAddressString[i] &&
	        i < strlen ( pIPAddressString) )
	{
		char digit = pIPAddressString[i];
		if ( isdigit ( digit ) == 0 &&
		    digit != '.' )
		{
			break;
		}
		j = (digit == '.' ? j + 1 : j);
		pIPAddress[j] = pIPAddress[j] * 10 + atoi ( &digit );
		
		i++;
	}
	return pIPAddress[3] + ((DWORD)pIPAddress[2] << 8) + ((DWORD)pIPAddress[1] << 16) + ((DWORD)pIPAddress[0] << 24);
}

/*******************************************************************************
**
**  Function:  getIPAddressStringofDecimalArray
**
**  Purpose:   Convert a byte array into an IP Address text string and an unsigned long single value
**
*******************************************************************************/
DWORD getIPAddressStringOfDecimalArray ( BYTE *pIPAddress, char *pIPAddressString )
{
	BYTE i = 0;  // string index
	BYTE j = 0;  // decimal number index
	
	sprintf_s ( &pIPAddressString[0], MAX_IPV4_ADDRESS_LENGTH,
	            "%d.%d.%d.%d",
	            pIPAddress[0],
	            pIPAddress[1],
	            pIPAddress[2],
	            pIPAddress[3] );

	return pIPAddress[3] + ((DWORD)pIPAddress[2] << 8) + ((DWORD)pIPAddress[1] << 16) + ((DWORD)pIPAddress[0] << 24);
}