#pragma once

// DoIP Payload Types
#define NACKRESPONSE                         0x0000  // Generic DoIP Header Negative Acknowledge, UDP_DISCOVERY/UDP_TEST_EQUIPMENT_REQUEST/TCP_DATA
#define VEHICLEIDENTIFICATIONREQUEST         0x0001  // Vehicle Identification Request Message, UDP_DISCOVERY
#define VEHICLEIDENTIFICATIONREQUEST_WITHEIN 0x0002  // Vehicle Identification Request Message with EID, UDP_DISCOVERY
#define VEHICLEIDENTIFICATIONREQUEST_WITHVIN 0x0003  // Vehicle Identification Request Message with VIN, UDP_DISCOVERY
#define VEHICLEIDENTIFICATIONRESPONSE        0x0004  // Vehicle Announcement Message/Vehicle Identification Response Message, UDP_DISCOVERY/UDP_TEST_EQUIPMENT_REQUEST
#define ROUTINGACTIVATIONREQUEST             0x0005  // Routing Activation Request, TCP_DATA
#define ROUTINGACTIVATIONRESPONSE            0x0006  // Routing Activation Response, TCP_DATA
#define ALIVECHECKREQUEST                    0x0007  // Alive Check Request, TCP_DATA
#define ALIVECHECKRESPONSE                   0x0008  // Alive Check Response, TCP_DATA
//                                           0X00090X4000,  Reserved by ISO 13400
#define ENTITYSTATUSREQUEST                  0x4001  // DoIP Entity Status Request, UDP_DISCOVERY
#define ENTITYSTATUSRESPONSE                 0x4002  // DoIP Entity Status Response, UDP_TEST_EQUIPMENT_REQUEST
#define POWERMODEREQUEST                     0x4003  // Diagnostic Power Mode Information Request, UDP_DISCOVERY
#define POWERMODERESPONSE                    0x4004  // Diagnostic Power Mode Information Response, UDP_TEST_EQUIPMENT_REQUEST
//                                           0X40050X8000, Reserved by ISO 13400
#define DIAGNOSTICMSGREQUEST                 0x8001  // Diagnostic Request Message, TCP_DATA
#define DIAGNOSTICMSGRESPONSE                0x8001  // Diagnostic Response Message, TCP_DATA
#define DIAGNOSTICMSG_POSITIVERESPONSE       0x8002  // Diagnostic Message Positive Acknowledgement, TCP_DATA
#define DIAGNOSTICMSG_NEGATIVERESPONSE       0x8003  // Diagnostic Message Negative Acknowledgement, TCP_DATA
//                                           0X80040XEFFF, Reserved by ISO 13400
//                                           0xF0000XFFFF, Reserved for manufacturer-specific use (OEM)


// DoIP Header NACK Codes
#define INCORRECT_PATTERN_FORMAT  0x00  // Incorrect pattern format, Close socket
#define UNKNOWN_PAYLOAD_TYPE      0x01  // Unknown payload type,     Discard DoIP message
#define MESSAGE_TOO_LARGE         0x02  // Message too large,        Discard DoIP message
#define OUT_OF_MEMORY             0x03  // Out of memory,            Discard DoIP message
#define INVALID_PAYLOAD_LENGTH    0x04  // Invalid payload length,   Close socket
//                                0x050xFF  Reserved by ISO 13400


// DoIP Protocol NACK Codes
//                                0x000x01  Reserved by ISO 13400
#define INVALIDSOURCEADDRESS      0x02  // Invalid source address
#define UNKNOWNTARGETADDRESS      0x03  // Unknown target address
#define MESSAGETOOLONG            0x04  // Diagnostic message too large
#define OUTOFMEMORY               0x05  // Out of memory
#define TARGETUNREACHABLE         0x06  // Target unreachable
#define UNKNOWNNETWORK            0x07  // Unknown network
#define TRANSPORTPROTOCOLERROR    0x08  //  Transport protocol error
//                                0x090xFF  Reserved by ISO 13400


#define NUM_SOCKET_ERRORS  49

enum Socket_Error_Codes
{
	eSocketTimeout = NUM_SOCKET_ERRORS,
	eSocketClosed,
	eSocketConnectionClosing,
	eSocketMissingLocalIPAddress,
	eSocketCreateEvent,
	eSocketStartThread,
	eWaitForError,
	eUnexpectedMessage,
	eOutputQueueFull,
	eMaxSocketErrorCodes,
};

#define PACKET_SIZE     1536
#define TEST_ADDRESSES  100

#define swap_short(a, b) (b = a[0]; a[0] = a[1]; a[1] = b)

#pragma pack(1)

typedef struct SocketData
{
	DWORD          ulAddress;
	WORD           usPort;
	SOCKET         hSock;
	SOCKADDR_IN    remote_sin;
	int            iError;
	long           lThread;
	boolean        bConnected;
	boolean        bStop;
} t_stSocketData;


typedef struct DOIPHeader
{
	BYTE  ucVersion;
	BYTE  ucInvVersion;
	unsigned short usRequest;
	unsigned long  ulLength;
} t_stDOIPHeader;


typedef struct DOIPPayload
{
	WORD  usSourceAddress;
	WORD  usTargetAddress;
	BYTE  ucUDSData;
} t_stDOIPPayload;


typedef struct UDSData
{
	BYTE  ucServiceID;
	BYTE  ucFirstByteOfData;
} t_stUDSData;


typedef struct VIDInfo
{
	char  acVIN[17];
	unsigned short usLogicalAddress;
	BYTE  aucEID[6];
	BYTE  aucGID[6];
	BYTE  ucAction;
	BYTE  ucSync;
} t_sVIDInfo;

typedef struct VIDResponse
{
	t_stDOIPHeader stHeader;
	t_sVIDInfo     Info;
} t_sVIDResponse;


typedef struct PMResponse
{
	t_stDOIPHeader stHeader;
	BYTE           ucMode;
} t_stPMResponse;


typedef struct EntityStatusInfo
{
	BYTE           ucNodeType;
	BYTE           ucMaxSockets;
	BYTE           ucOpenSockets;
	DWORD          ulMaxSize;
} t_stEntityStatusInfo;

typedef struct StatusResponse
{
	t_stDOIPHeader       stHeader;
	t_stEntityStatusInfo Info;
} t_stStatusResponse;


typedef struct ActivationRequest
{
	t_stDOIPHeader stHeader;
	unsigned short usSourceAddress;
	BYTE           ucAtivationType;
	unsigned long  ulReserved;
} t_stActivationRequest;


typedef struct ActivationInfo
{
	unsigned short usLogicalAddress;
	unsigned short usSourceAddress;
	BYTE           ucAtivationResponse;
	unsigned long  ulReserved;
} t_stActivationInfo;

typedef struct ActivationResponse
{
	t_stDOIPHeader     stHeader;
	t_stActivationInfo Info;
} t_stActivationResponse;


typedef struct IPAddressInfo
{
	BYTE                 IPv4Address[4];
	DWORD                ulIPv4Address;
	BYTE                 IPv6Address[16];
	BOOL                 bVehicleIdentifictionResponse;
	t_sVIDInfo           VehicleIdenificationInfo;
	BOOL                 bPowerModeResponse;
	BYTE                 PowerModeInfo;
	BOOL                 bEntiyStatusResponse;
	t_stEntityStatusInfo EntityStatusInfo;
	BOOL                 bAtivationResponse;
	unsigned long  ulReserved;
} t_stIPAddressInfo;


#pragma pack()

char* GetEthernetErrorString ( int iError );

long OpenChannel ( unsigned long  ulTesterAddress,
                   char          *pcTesterAddress,
                   char          *pcVehicleAddress,
                   unsigned short usTesterPort,
                   unsigned short usTesterAddress );
