/*******************************************************************************
********************************************************************************
**
**  Copyright(c) 2022, Alliance for Automotive Innovation
**  Used only under license from the Alliance for Automotive Innovation. All Rights Reserved.
**
**  Project:  J1699-5
**  FileName: StopTest.c
**  Author:   EnGenius
**  Date:     2/25/2022
**  Email:    <support@autosinnovate.org>
**
**  Purpose:  SAE J1699-5 Vehicle OBD II Compliance Test Cases Source Code.
**            This source code is intended to run the tests described in
**            the SAE J1699-5 document in an automated manner, when compiled
**            and used with an SAE J2534-compatible pass-thru device.
**
**            File j1699.c contains information on building and running this test.
**
**  Description:
**
**  Modifications:  03/13/2023  Initial Version
**
********************************************************************************
*******************************************************************************/

#include <stdio.h>    // C Library input and output declarations
#include <stdlib.h>   // C Library general function declarations
#include <time.h>     // C Library time and date declarations
#include <conio.h>    // MS-DOS console input and output declarations
#include <windows.h>  // Windows API declarations
#include "j2534.h"    // j1699 project j2534 declarations
#include "j1699.h"    // j1699 project general declarations


extern HINSTANCE hDLL;

extern char            gTempLogFilenameString[MAX_PATH];


/*******************************************************************************
**
**  Function:  StopTest
**
**  Purpose:   Stop all tests
**
*******************************************************************************/
void StopTest ( STATUS      ExitStatus,
                TEST_PHASE  eTestPhase )
{
	if ( ExitStatus == FAIL ||
	     gbTestFailed == TRUE )
	{
		if ( eTestPhase == eTestInUseCounters )
		{
			// results will be saved in the temporary file
			Log ( BLANK, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT, "\n\n" );
			Log ( RESULTS, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "**** Failures detected, view %s file ****\n\n",
			      gTempLogFilenameString );
		}
		else
		{
			// results will be saved in the 'VIN' file
			Log ( BLANK, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT, "\n\n" );
			Log ( RESULTS, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "**** Failures detected, view %s file ****\n\n",
			      gLogFileNameString );
		}
	}
	else if ( gbTestAborted == TRUE )
	{
		if ( eTestPhase == eTestInUseCounters )
		{
			// results will be saved in the temporary file
			Log ( BLANK, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT, "\n\n" );
			Log ( RESULTS, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "**** Test terminated by user, view %s file ****\n\n",
			      gTempLogFilenameString );
		}
		else
		{
			// results will be saved in the 'VIN' file
			Log ( BLANK, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT, "\n\n" );
			Log ( RESULTS, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "**** Test terminated by user, view %s file ****\n\n",
			      gLogFileNameString );
		}
	}

	if ( eTestPhase != eTestNone )
	{
		DisconnectOBDProtocol ( );

		// don't care about J2534 failures here
		PassThruClose ( gDeviceID );
	}

	// close any open log files
	fclose ( gTempLogFileHandle );
	fclose ( gLogFileHandle );

	// don't save the 'VIN' file if test 10 did not complete successfully,
	// move contents to the temporary file
	if ( eTestPhase == eTestInUseCounters )
	{
		if ( gTempLogFileHandle != gLogFileHandle )
		{
			if ( DeleteFile ( gTempLogFilenameString ) == 0 )
			{
				printf ( "Unable to delete tempfile %s.",
				         gTempLogFilenameString );
			}
			else if ( MoveFile ( gLogFileNameString, gTempLogFilenameString ) == 0 )
			{
				printf ( "Unable to move logfile to tempfile %s.",
				         gTempLogFilenameString );
			}
		}

		printf ( "Test 10 did not complete successfully.\n"
		         "Results so far saved in tempfile %s.",
		         gTempLogFilenameString );
	}
	else
	{
		if ( DeleteFile ( gTempLogFilenameString ) == 0 )
		{
			printf ( "Unable to delete tempfile %s.",
			         gTempLogFilenameString );
		}
	}

	if ( hDLL != NULL )
	{
		if ( !FreeLibrary ( hDLL ) )
		{
			Log ( FAILURE, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
			      "Unable to Free J2534 DLL\n\n" );
		}
	}
}
