/*******************************************************************************
********************************************************************************
**
**  Copyright(c) 2022, Alliance for Automotive Innovation
**  Used only under license from the Alliance for Automotive Innovation. All Rights Reserved.
**
**  Project:  J1699-5
**  FileName: Test12_ZEV.c
**  Author:   EnGenius
**  Date:     2/25/2022
**  Email:    <support@autosinnovate.org>
**
**  Purpose:  SAE J1699-5 Vehicle OBD II Compliance Test Cases Source Code.
**            This source code is intended to run the tests described in
**            the SAE J1699-5 document in an automated manner, when compiled
**            and used with an SAE J2534-compatible pass-thru device.
**
**            File j1699.c contains information on building and running this test.
**
**  Description:
**
**  Modifications:  012/05/2023  Initial Version
**
********************************************************************************
*******************************************************************************/

#include <stdio.h>    // C Library input and output declarations
#include <stdlib.h>   // C Library general function declarations
#include <time.h>     // C Library time and date declarations
#include <windows.h>  // Windows API declarations
#include "j2534.h"    // j1699 project j2534 declarations
#include "j1699.h"    // j1699 project general declarations


// Function Prototypes
//STATUS TestDIDs ( void );

extern STATUS ReadProtocolID      ( void );
extern STATUS CheckMIL            ( void );
extern void   InitOBDProtocolList ( void );

//extern WORD gTestDID[];
//extern BYTE gTestDIDCount;


/*******************************************************************************
**
**  Function:  Test5_NoDTC
**
**  Purpose:   Run test 5 with no malfunction, no DTC set
**
*******************************************************************************/
STATUS Test12_ZEV ( void )
{
	BOOL          bSubTestFailed = FALSE;


//*******************************************************************************
//  Test 12.1 - Determine the OBD protocol to use
//*******************************************************************************
	gTestSubsection = 1;
	gbTestSubsectionFailed = FALSE;
	bSubTestFailed = FALSE;

	Log ( SUBSECTION_BEGIN, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
	      "(Determine Protocol)" );


	Log ( PROMPT, SCREENOUTPUTON, LOGOUTPUTON, ENTER_PROMPT,
	      "Perform whatever steps are required for the vehicle to communicate via DoIP." );


	gbIgnoreUnsupported = TRUE;
	// Determine the OBD protocol to use
	if ( DetermineOBDProtocol ( ) != PASS )
	{
		Log ( FAILURE, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
		      "Protocol determination unsuccessful.\n" );
		Log ( SUBSECTION_FAILED_RESULT, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT, "" );
		return FAIL;
	}

	Log ( BLANK, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
	      "\n" );

//	if ( gTestDIDCount == 0 )
	{
		Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
		      "Reading Protocol ID\n" );
		if ( ReadProtocolID ( ) != PASS )
		{
			bSubTestFailed = TRUE;
		}
	}
//	else
//	{
//		Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
//		      "Reading Test DID(s)\n" );
//		if ( TestDIDs ( ) != PASS )
//		{
//			bSubTestFailed = TRUE;
//		}
//	}
	gbIgnoreUnsupported = FALSE;

//*******************************************************************************
//  Test 12.x - ZEV Tests
//*******************************************************************************
	Log ( PROMPT, SCREENOUTPUTON, LOGOUTPUTOFF, ENTER_PROMPT,
	      "*** Further ZEV Tests NOT CURRENTLY IMPLEMENTED ***\n" );

	return PASS;
}




/*******************************************************************************
**
**  Function:  TestDIDs
**
**  Purpose:   Read a PID (Protocol ID) data from each ECU
**
*******************************************************************************/
//STATUS TestDIDs ( void )
//{
//	BYTE     EcuIdx;
//	REQ_MSG  stReqMsg;
//
//	BYTE     DIDIndex;
//	BYTE    *pDID = NULL;
//	BYTE     String[MAX_RESP_BUF_SIZE*5];
//	DWORD    StringIdx = 0;
//	WORD     Size = 0;
//	STATUS   RetCode = PASS;
//
//	for ( DIDIndex = 0;
//	      DIDIndex < gTestDIDCount;
//	      DIDIndex++ )
//	{
//		stReqMsg.SID      = 0x22;
//		stReqMsg.NumIds   = 1;
//		stReqMsg.u.DID[0] = gTestDID[DIDIndex];
//		if ( RequestSID ( &stReqMsg, REQ_MSG_NO_PERIODIC_DISABLE|REQ_MSG_IGNORE_NO_RESPONSE ) == FAIL )
//		{
//			Log ( FAILURE, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
//			      "DID $%04X request\n",
//			      gTestDID[DIDIndex] );
//			RetCode = FAIL;
//			continue;
//		}
//
//		for ( EcuIdx = 0; EcuIdx < gUserNumOfECUs; EcuIdx++ )
//		{
//			// If DID is not supported, skip to next ECU
//			if ( !gbIgnoreUnsupported &&
//			     ((gTestDID[DIDIndex] >= 0xF400 && gTestDID[DIDIndex] <= 0xF5FF && IsIDSupported ( EcuIdx, PIDREQUEST, gTestDID[DIDIndex] ) == FALSE) ||
//			      (gTestDID[DIDIndex] >= 0xF800 && gTestDID[DIDIndex] <= 0xF8FF && IsIDSupported ( EcuIdx, INFREQUEST, gTestDID[DIDIndex] ) == FALSE)) )
//			{
//				continue;
//			}
//
//			if ( gstResponse[EcuIdx].bResponseReceived )
//			{
//				if ( (gTestDID[DIDIndex] >= 0xF400 && gTestDID[DIDIndex] <= 0xF5FF && gstResponse[EcuIdx].PIDSize == 0) ||
//				     (gTestDID[DIDIndex] >= 0xF800 && gTestDID[DIDIndex] <= 0xF8FF && gstResponse[EcuIdx].INFSize == 0) )
//				{
//					Log ( FAILURE, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
//					      "ECU %X  DID $%04X no data\n",
//					      GetEcuId ( EcuIdx ),
//					      gTestDID[DIDIndex] );
//					RetCode = FAIL;
//				}
//				else
//				{
//					if ( gTestDID[DIDIndex] >= 0xF400 && gTestDID[DIDIndex] <= 0xF5FF )
//					{
//						pDID = (BYTE*)&gstResponse[EcuIdx].PID[0];
//						Size = gstResponse[EcuIdx].PIDSize;
//					}
//					else if ( gTestDID[DIDIndex] >= 0xF800 && gTestDID[DIDIndex] <= 0xF8FF )
//					{
//						pDID = (BYTE*)&gstResponse[EcuIdx].INF[0];
//						Size = gstResponse[EcuIdx].INFSize;
//					}
//
// 					String[0] = (BYTE)NULL;
//					for ( int i = 0;
//					      i < Size;
//					      i++ )
//					{
//						StringIdx += sprintf_s ( &String[strlen ( String )], (MAX_RESP_STR_SIZE) - StringIdx,
//						                         "%02X ",
//						                         pDID[i] );
//					}
////					String[strlen(String)] = (BYTE)NULL;
//					Log ( INFORMATION, SCREENOUTPUTON, LOGOUTPUTON, NO_PROMPT,
//					      "ECU %X  DID $%04X  %s\n",
//					      GetEcuId ( EcuIdx ),
//					      gTestDID[DIDIndex],
//					      String );
//				}
//			}  // end if ( PID/INF datasize != 0 )
//		}  // end for ( EcuIdx )
//	}  // end for ( DIDIndex )
//
//	return RetCode;
//}
