/*******************************************************************************
********************************************************************************
**
**  Copyright(c) 2022, Alliance for Automotive Innovation
**  Used only under license from the Alliance for Automotive Innovation. All Rights Reserved.
**
**  Project:  J1699-5
**  FileName: j2534.h
**  Author:   EnGenius
**  Date:     2/25/2022
**  Email:    <support@autosinnovate.org>
**
**  Purpose:  SAE J1699-5 Vehicle OBD II Compliance Test Cases Source Code.
**            This source code is intended to run the tests described in
**            the SAE J1699-5 document in an automated manner, when compiled
**            and used with an SAE J2534-compatible pass-thru device.
**
**            File j1699.c contains information on building and running this test.
**
**  Description:
**
**  Modifications:  03/13/2023  Initial Version
**
********************************************************************************
*******************************************************************************/

#ifndef __J2534_H
#define __J2534_H


// PassThruConnect Protocol definitions
#define J1850VPW                                0x00000001
#define J1850PWM                                0x00000002
#define ISO9141                                 0x00000003
#define ISO14230                                0x00000004
#define CAN                                     0x00000005
#define ISO15765                                0x00000006
#define J2610                                   0x00000007
#define SCI_A_ENGINE                            0x00000007
#define SCI_A_TRANS                             0x00000008
#define SCI_B_ENGINE                            0x00000009
#define SCI_B_TRANS                             0x0000000A
// Reserved for SAE use                         0x0000000B  0x00007FFF
// Reserved for SAE J2534-2                     0x00008000 - 0x0000FFFF
// Tool manufacturer specific                   0x00010000 - 0xFFFFFFFF

// Used by SAE J2534-2 (API Version 04.04)      0x00000000 - 0x00008007
// Reserved for physical communication channels 0x00000008 - 0x000001FF
#define ISO15765_LOGICAL                        0x00000200
// Reserved for logical communication channels  0x00000201 - 0x000003FF
// Reserved for SAE J2534-1                     0x00000400 - 0x00007FFF
// Used by SAE J2534-2 (API Version 04.04)      0x00008000 - 0x00008007
#define SW_CAN                                  0x00008008
#define GM_UART                                 0x00008009
#define UART_ECHO_BYTE                          0x0000800A
#define HONDA_DIAGH                             0x0000800B
// Used by SAE J2534-2 (API Version 04.04)      0x0000800C
#define SAE_J1708                               0x0000800D
// Used by SAE J2534-2 (API Version 04.04)      0x0000800E
#define FT_CAN                                  0x0000800F
// Used by SAE J2534-2 (API Version 04.04)      0x00008010
#define FD_CAN                                  0x00008011
// Used by SAE J2534-2 (API Version 04.04)      0x00008012
#define ETHERNET_NDIS                           0x00008013
#define DOIP_NDIS                               0x00008013
// Reserved for SAE J2534-2                     0x00008014
#define ETHERNET                                0x00008015
#define DOIP                                    0x00008015
// Reserved for SAE J2534-2                     0x00008016 - 0x000081FF
#define J1939_LOGICAL                           0x00008200
#define TP2_0_LOGICAL                           0x00008201
// Reserved for SAE J2534-2                     0x00008202
#define IP4_LOGICAL                             0x00008203
#define IP6_LOGICAL                             0x00008204
#define UDP_LOGICAL                             0x00008205
#define TCP_CLIENT_LOGICAL                      0x00008206
// Reserved for SAE J2534-2                     0x00008207 - 0x00008FFF
// Used by SAE J2534-2 (API Version 04.04)      0x00009000 - 0x0000997F
// Reserved for SAE J2534-2                     0x00009980 - 0x0000BFFF
#define ANALOG_IN                               0x0000C000
// Used by SAE J2534-2 (API Version 04.04)      0x0000C001 - 0x0000C01F
// Reserved for SAE J2534-2                     0x0000C020 - 0x0000FFFF
// Tool Manufacturer Specific                   0x00010000 - 0xFFFFFFFF


// PassThruIoctl IDs
#define GET_CONFIG                         0x00000001
#define SET_CONFIG                         0x00000002
#define READ_PIN_VOLTAGE                   0x00000003
#define READ_VBATT                         0x00000003
#define FIVE_BAUD_INIT                     0x00000004
#define FAST_INIT                          0x00000005
#define CLEAR_TX_QUEUE                     0x00000007
#define CLEAR_TX_BUFFERS                   0x00000007
#define CLEAR_TX_BUFFER                    0x00000007
#define CLEAR_RX_QUEUE                     0x00000008
#define CLEAR_RX_BUFFERS                   0x00000008
#define CLEAR_RX_BUFFER                    0x00000008
#define CLEAR_PERIODIC_MSGS                0x00000009
#define CLEAR_MSG_FILTERS                  0x0000000A
#define CLEAR_FUNCT_MSG_LOOKUP_TABLE       0x0000000B
#define ADD_TO_FUNCT_MSG_LOOKUP_TABLE      0x0000000C
#define DELETE_FROM_FUNCT_MSG_LOOKUP_TABLE 0x0000000D
#define READ_PROG_VOLTAGE                  0x0000000E
#define BUS_ON                             0x0000000F
// Used by SAE J2534-2 (API Version 04.04) 0x00008000 - 0x00008003
#define START_REPEAT_MESSAGE               0x00008004
#define QUERY_REPEAT_MESSAGE               0x00008005
#define STOP_REPEAT_MESSAGE                0x00008006
#define GET_DEVICE_CONFIG                  0x00008007
#define SET_DEVICE_CONFIG                  0x00008008
#define PROTECT_J1939_ADDR                 0x00008009
#define REQUEST_CONNECTION                 0x0000800A
#define TEARDOWN_CONNECTION                0x0000800B
#define GET_DEVICE_INFO                    0x0000800C
#define GET_PROTOCOL_INFO                  0x0000800D
// Used by SAE J2534-2 (API Version 04.04) 0x0000800E - 0x0000800E
#define GET_NDIS_ADAPTER_INFO              0x0000800F
#define GET_RESOURCE_INFO                  0x00008010
#define NS_AUTO_CHANGE_MSG                 0x00008011
#define HS_AUTO_CHANGE_MSG                 0x00008012
#define NON_BLOCKING_FIVE_BAUD_INIT        0x00008013
#define NON_BLOCKING_FAST_INIT             0x00008014
#define GET_ANALOG_CHANNEL_INFO            0x00008015
// Reserved for SAE J2534-2                0x00008016 - 0x0000801F
#define SET_MAC_ADDRESS                    0x00008020
#define GET_MAC_ADDRESS                    0x00008021
#define ETH_ACTIVATION_PULLUP              0x00008022
#define GET_SOCKET_STATE                   0x00008023
#define GET_DATALENGTH_IN_FIRST_PTMSG      0x00008024
#define IP4_GET_ADDRESS_INFO               0x00008025
#define IP6_GET_ADDRESS_INFO               0x00008026
#define GET_DEVICE_NAME                    0x00008027
// Reserved for SAE J2534-2                0x00008028 - 0x0000FFFF
// Tool Manufacturer Specific              0x00010000 - 0xFFFFFFFF
#define GET_VCI_SERIAL_NO                  0x00030000
#define GET_VCI_TYPE                       0x00030001


#define READ_CH1_VOLTAGE           0x10000
#define READ_CH2_VOLTAGE           0x10001
#define READ_CH3_VOLTAGE           0x10002
#define READ_CH4_VOLTAGE           0x10003
#define READ_CH5_VOLTAGE           0x10004
#define READ_CH6_VOLTAGE           0x10005


// Configuration Parameter IDs
#define DATA_RATE                  1
#define LOOPBACK                   3
#define NODE_ADDRESS               4
#define NETWORK_LINE               5
#define P1_MIN                     6
#define P1_MAX                     7
#define P2_MIN                     8
#define P2_MAX                     9
#define P3_MIN                     10
#define P3_MAX                     11
#define P4_MIN                     12
#define P4_MAX                     13
#define W1                         14
#define W2                         15
#define W3                         16
#define W4                         17
#define W5                         18
#define TIDLE                      19
#define TINIL                      20
#define TWUP                       21
#define PARITY                     22
#define BIT_SAMPLE_POINT           23
#define SYNC_JUMP_WIDTH            24
#define T1_MAX                     26
#define T2_MAX                     27
#define T4_MAX                     28
#define T5_MAX                     29
#define ISO15765_BS                30
#define ISO15765_STMIN             31
#define DATA_BITS                  100

#define CAN_MIXED_FORMAT           0x08000

#define ADC_READINGS_PER_SECOND    0x10000


// Error IDs 
#define STATUS_NOERROR             0x00
#define ERR_NOT_SUPPORTED          0x01
#define ERR_INVALID_CHANNEL_ID     0x02
#define ERR_INVALID_PROTOCOL_ID    0x03
#define ERR_NULL_PARAMETER         0x04
#define ERR_INVALID_IOCTL_VALUE    0x05
#define ERR_INVALID_FLAGS          0x06
#define ERR_FAILED                 0x07
#define ERR_DEVICE_NOT_CONNECTED   0x08
#define ERR_TIMEOUT                0x09
#define ERR_INVALID_MSG            0x0A
#define ERR_INVALID_TIME_INTERVAL  0x0B
#define ERR_EXCEEDED_LIMIT         0x0C
#define ERR_INVALID_MSG_ID         0x0D
#define ERR_DEVICE_IN_USE          0x0E
#define ERR_INVALID_IOCTL_ID       0x0F
#define ERR_BUFFER_EMPTY           0x10
#define ERR_BUFFER_FULL            0x11
#define ERR_BUFFER_OVERFLOW        0x12
#define ERR_PIN_INVALID            0x13
#define ERR_CHANNEL_IN_USE         0x14
#define ERR_MSG_PROTOCOL_ID        0x15
#define ERR_INVALID_FILTER_ID      0x16
#define ERR_NO_FLOW_CONTROL        0x17
#define ERR_NOT_UNIQUE             0x18
#define ERR_INVALID_BAUDRATE       0x19
#define ERR_INVALID_DEVICE_ID      0x1A


// Miscellaneous definitions 
#define SHORT_TO_GROUND            0xFFFFFFFE
#define VOLTAGE_OFF                0xFFFFFFFF
#define NO_PARITY                  0
#define ODD_PARITY                 1
#define EVEN_PARITY                2


// RxStatus definitions 
#define TX_MSG_TYPE                0x00000001
#define ISO15765_FIRST_FRAME       0x00000002
#define START_OF_MESSAGE           0x00000002
#define RX_BREAK                   0x00000004
#define TX_DONE                    0x00000008
#define ISO15765_PADDING_ERROR     0x00000010
#define ISO15765_ADDR_TYPE         0x00000080
#define CAN_29BIT_ID               0x00000100


// PassThruConnect TxFlags definitions 
#define TX_NORMAL_TRANSMIT         0x00000000
#define FULL_DUPLEX                0x00000001
// Reserved for SAE                0x00000002
// Reserved for SAE J2534-1        0x00000004,08,10,20,40,80
#define ISO15765_FRAME_PAD         0x00000040
#define ISO15765_EXT_ADDR          0x00000080
//      ISO15765_ADDR_TYPE         0x00000080  // see RxStatus definitions
#define CAN_EXTENDED_ID            0x00000100
//      CAN_29BIT_ID               0x00000100  // see RxStatus definitions
#define CHECKSUM_DISABLED          0x00000200
#define ISO9141_NO_CHECKSUM        0x00000200
#define WAIT_P3_MIN_ONLY           0x00000200
// Reserved for SAE                0x00000400
#define CAN_ID_BOTH                0x00000800
#define K_LINE_ONLY                0x00001000
#define ISO9141_K_LINE_ONLY        0x00001000
// Reserved for SAE J2534-1        0x00002000,4000,8000
#define NDIS_PINS_OPTION1          0x00010000
#define ETH_FLAG_MANUAL_NEGOTIATE  0x00010000
#define RECEIVE_BROADCAST          0x00010000
#define TX_BLOCKING                0x00010000
#define ISO15765_ON_J1939          0x00020000
#define ETH_FLAG_HALF_DUPLEX       0x00020000
#define NDIS_PINS_OPTION2          0x00020000
#define NDIS_PINS_AUTO_DETECT      0x00030000
// Reserved for SAE J2534-2        0x00040000,80000,100000,200000,400000
#define SCI_MODE                   0x00400000
#define SCI_TX_VOLTAGE             0x00800000
#define LISTEN_ONLY                0x00800000
// Tool Manufacturer Specific      0x01000000-80000000
#define CONNECT_ETHERNET_ONLY      0x80000000


// Filter definitions 
#define PASS_FILTER                0x00000001
#define BLOCK_FILTER               0x00000002
#define FLOW_CONTROL_FILTER        0x00000003


// Ioctl parameter CAN_MIXED_FORMAT definitions 
#define CAN_MIXED_FORMAT_OFF         0 // Messages treated as ISO15765 only
#define CAN_MIXED_FORMAT_ON          1 // Messages treated as ISO15765 or unformated CAN Frame
#define CAN_MIXED_FORMAT_ALL_FRAMES  2 // Messages treated as ISO15765 or unformated CAn Frame or both


#define MAX_MSG_LEN 4128
// Message Structure 
typedef struct
{
	unsigned long eProtocolID;
	unsigned long RxStatus;
	unsigned long TxFlags;
	unsigned long TimestampMsecs;
	unsigned long DataSize;
	unsigned long ExtraDataIndex;
	BYTE          Data[MAX_MSG_LEN];
} PASSTHRU_MSG;

// IOCTL Structures 
typedef struct
{
	unsigned long Parameter;
	unsigned long Value;
} SCONFIG;

typedef struct
{
	unsigned long NumOfParams;
	SCONFIG *ConfigPtr;
} SCONFIG_LIST;

typedef struct
{
	unsigned long NumOfBytes;
	BYTE          *BytePtr;
} SBYTE_ARRAY;

typedef struct
{
	unsigned long NumOfPins;
	BYTE          *PinUsePtr;
} SPIN_CONTROL;

typedef struct
{
	unsigned long PinNumber;
	unsigned long PinUse;
	unsigned long Parameter;
} SPIN_USE;

typedef struct
{
	char Name[128];         // Adapter name - ASCII Null terminated.
	char DeviceName[64];    // Device  name - ASCII Null terminated.
	unsigned long Status;   // Adapter Status - 0 for disabled, 1 for enabled.
	BYTE MAC_Address[6];    // The Media Access Control (MAC) Address  of the  Network interface
	                        // in the PC that is to be connected to the vehicle.
	BYTE IPV6_Address[16];  // The Ipv6 address assigned to the Network interface.
	                        // No compressed or short form notation.
	                        // If not available, all bytes are set to zero to imply the absence of  an address.
	                        // In network byte order, big endian format.
	BYTE IPV4_Address[4];   // The Ipv4 address assigned to the Network interface.
	                        // If not available, all bytes are set to zero.
	                        // In network byte order, big endian format.
	unsigned long EthernetPinConfig;  // the current Ethernet pin configuration for the NDIS adapter; 1=Option 1, 2=Option 2
} SADAPTER_INFO;

#endif // __J2534_H 
